<?php

namespace App\Http\Controllers\Driver;

use App\Http\Controllers\Controller;
use App\Models\DriverBankCards;
use App\Services\MyService;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class BankCardsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try {

            $driver_id = auth('driver')->id();

            $cards = DriverBankCards::where('driver_id', $driver_id)
                ->where('is_deleted', false)
                ->get();

            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد',
                'response' => $cards
            ]);

        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): object
    {
        try {

            $validator = Validator::make($request->all(), [
                'bank_name' => ['required', 'string', 'max:255'],
                'card_number' => ['required', 'numeric', 'digits:16'],
                'shaba_number' => ['required', 'numeric', 'digits:24'],
                'card_name' => ['required', 'string', 'max:255'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ], 422);
            }

            $data = $validator->validated();
            $data['driver_id'] = auth('driver')->id();

          $create = DriverBankCards::create($data);

          if ($create) {
              return response()->json([
                  'success' => true,
                  'message' => 'عملیات با موفقیت انجام شد',
                  'id' => $create->id
              ]);
          }

            return response()->json([
                'success' => false,
                'message' => 'متاسفانه عملیات انجام نشد',
            ],500);

        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id): object
    {
        try {

            $validator = Validator::make(['id' => $id], [
                'id' => ['required', 'integer', 'exists:driver_bank_cards,id'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ],422);
            }

          $card = DriverBankCards::find($id);

            try {
                MyService::checkRealPerson($card->driver_id, 'driver');
            } catch (\Exception $e) {
                return $e->response();
            }

            $card->is_deleted = true;
            $card->save();

            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد'
            ]);

        }catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }
}
