<?php

namespace App\Http\Controllers\Common;

use App\Http\Controllers\Controller;
use App\Models\Support;
use App\Services\MyService;
use Exception;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SupportController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): object
    {
        try {

            if (auth('user')->check()) {
                $guard = 'user';
                $id = auth('user')->id();

            } elseif (auth('driver')->check()) {
                $guard = 'driver';
                $id = auth('driver')->id();

            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'احراز هویت شما تایید نشد !'
                ], 401);
            }

            $supports = Support::where(['uid' => $id, 'user_type' => $guard])
                ->get()
                ->map(function ($support) {

                    $date = explode(' ', MyService::G2J($support->created_at));
                    return [
                        'date' => $date[0],
                        'time' => $date[1],
                        'title' => $support->title,
                        'description' => $support->description,
                        'answer' => $support->answer,
                    ];

                });


            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد',
                'response' => $supports
            ]);

        } catch (Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): object
    {
        try {

            $validator = Validator::make($request->all(), [
                'title' => ['required', 'string', 'max:255'],
                'description' => ['required', 'string', 'max:1000'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ], 422);
            }


            if (auth('user')->check()) {
                $guard = 'user';
                $id = auth('user')->id();

            } elseif (auth('driver')->check()) {
                $guard = 'driver';
                $id = auth('driver')->id();

            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'احراز هویت شما تایید نشد !'
                ], 401);
            }

            $support = $validator->validated();
            $support['uid'] = $id;
            $support['user_type'] = $guard;

            Support::create($support);

            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد',
            ]);

        } catch (Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
