<?php

namespace App\Http\Controllers\Common;

use App\Http\Controllers\Controller;
use App\Models\DriverCategories;
use Exception;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DriverCategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): object
    {
        try {

            $cats = DriverCategories::where('is_active', true)
                ->get()
                ->map(function ($cat) {

                    if (auth('panel')->check()) {
                        return $cat;
                    }

                        return [
                            'id' => $cat->id,
                            'name' => $cat->name,
                            'pic' => $cat->pic,
                            'type' => $cat->type,
                            'vehicle' => $cat->vehicle,
                        ];

                });


            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد',
                'response' => $cats
            ]);

        } catch (Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id): object
    {
        try {

            $validator = Validator::make(['id' => $id], [
                'id' => ['required', 'exists:driver_categories,id'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first(),
                ],422);
            }

            $validator = Validator::make($request->all(), [
                'name' => ['required', 'string', 'max:255'],
                'base_price' => ['required', 'numeric'],
                'kilometer_price' => ['required', 'numeric'],
                'is_active' => ['required', 'boolean'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first(),
                ],422);
            }

            if (DriverCategories::where('id', $id)->update($validator->validated())) {
                return response()->json([
                    'success' => true,
                    'message' => 'دسته بندی مورد نظر با موفقیت ویرایش شد'
                ]);
            }

            return response()->json([
                'success' => false,
                'message' => 'متاسفانه دسته بندی مورد نظر ویرایش نشد !'
            ], 500);

        }catch (Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
