<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Otps;
use App\Models\PanelUsers;
use App\Models\User;
use App\Services\MyService;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class OtpPanelController extends Controller
{
    public function sendCode(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'mobile' => ['required', 'regex:/^09\d{9}$/'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ], 422);
            }

            $user = PanelUsers::where('mobile', $request['mobile'])->first();

            if (!$user) {
                return response()->json([
                    'success' => false,
                    'message' => 'احراز هویت شما تایید نشد !',
                ], 401);
            }

            $code = random_int(100000, 999999);

            $user->update(
                [
                    'code' => $code,
                    'expires_code' => now()->addMinutes()
                ]
            );


            MyService::MessageOtp($request['mobile'], $code);

            return response()->json([
                'success' => true,
                'message' => 'کد ارسال شد',
                'code' => $code
            ]);

        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);

        }

    }

    public function verifyCode(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'mobile' => ['required', 'regex:/^09\d{9}$/'],
                'code' => ['required', 'regex:/^([0-9\s\-\+\(\)]*)$/', 'numeric', 'digits:6'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ], 422);
            }


            $user = PanelUsers::where('mobile', $request['mobile'])->first();

            if ($user) {

                if ($user->code !== $request['code']) {
                    return response()->json([
                        'success' => false,
                        'message' => 'کد وارد شده تایید نشد !'
                    ], 403);
                }

                if ($user->expires_code <= now()) {
                    return response()->json([
                        'success' => false,
                        'message' => 'کد وارد شده معتبر  نمی باشد !'
                    ], 403);
                }

                if ($user->is_blocked) {
                    return response()->json([
                        'success' => false,
                        'message' => 'درحال حاظر پروفایل شما در دسترس نمی باشد !'
                    ], 403);
                }

                $user->tokens()->delete();

                $token = $user->createToken('auth_token', [$user->type]);

//                $token->accessToken->expires_at = now()->addHours(2);
                $token->accessToken->save();

                return response()->json([
                    'success' => true,
                    'message' => $user->username . ' ' . 'عزیز با موفقیت وارد شدید',
                    'token' => MyService::Encryption($token->plainTextToken) ,
                    'uid' => $user->id,
                    'user_type' => $user->type
                ]);
            }

            return response()->json([
                'success' => false,
                'message' => 'احراز هویت شما تایید نشد !',
            ], 401);


        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }

    }

}
