<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\DriverUser;
use App\Models\Otps;
use App\Models\User;
use App\Services\MyService;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class OtpDriverController extends Controller
{
    public function sendCode(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'mobile' => ['required', 'regex:/^09\d{9}$/'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ],422);
            }

            $request->validate(['mobile' => 'required']);

            $code = random_int(1000, 9999);

            Otps::updateOrCreate([
                'mobile' => $request['mobile']],
                [
                    'mobile' => $request->mobile,
                    'code' => $code,
                    'expires_at' => now()->addMinutes(2)
                ]);


            MyService::MessageOtp($request['mobile'], $code);

            return response()->json([
                'success' => true,
                'message' => 'کد ارسال شد',
                'code' => $code
            ]);

        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ],500);

        }

    }

    public function verifyCode(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'mobile' => ['required', 'regex:/^09\d{9}$/'],
                'code' => ['required', 'regex:/^([0-9\s\-\+\(\)]*)$/', 'numeric', 'digits:4'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ], 422);
            }


            $otp = Otps::where('mobile', $request->mobile)
                ->where('code', $request->code)
                ->where('expires_at', '>', now())
                ->first();

            if (!$otp) {
                return response()->json([
                    'success' => false,
                    'message' => 'کد وارد شده نامعتبر است'
                ], 403);
            }


            $driver = DriverUser::where('mobile', $request->mobile)->first();

            if (!$driver) {
                return response()->json([
                    'success' => true,
                    'message' => 'کد وارد شده صحیح می باشد',
                    'registered' => false
                ]);
            }

            if ($driver->is_blocked) {
                return response()->json([
                    'success' => false,
                    'message' => 'اکانت شما مسدود شده است. لطفاً با پشتیبانی تماس بگیرید.',
                ], 403);
            }

            if (!$driver->is_confirmation) {
                return response()->json([
                    'success' => false,
                    'message' => 'اکانت شما درحال بررسی است و هنوز تایید نشده است !',
                ], 403);
            }

            $token = $driver->createToken('auth_token', ['driver'])->plainTextToken;

            $username = $driver->first_name . ' ' . $driver->last_name;

            return response()->json([
                'success' => true,
                'message' => $username . ' ' . 'عزیز با موفقیت وارد شدید',
                'token' => $token,
                'registered' => true,
                'uid' => $driver->id
            ]);

        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ],500);
        }

    }

}
