<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Http\JsonResponse;

class ValidationReturn extends Exception
{
    public function render($request): object
    {
        return response()->json([
            'success' => false,
            'message' => $this->getMessage()
        ], 403);
    }

    public function response(): JsonResponse
    {
        return $this->render(request());
    }
}
