<?php
namespace App\Enums;

enum TravelStage: string
{
    case Pending = 'pending'; // انتظار برای تایید راننده
    case BeforeOrigin = 'before_origin'; // در مسیر مبدا
    case AtOrigin = 'at_origin'; // در مبدا
    case ToDestination = 'to_destination'; // در مسیر مقصد
    case AtDestination = 'at_destination'; // در مقصد
    case ToNextDestination = 'to_next_destination'; // بین مقصدها
    case ToOrigin = 'to_origin'; // در حال بازگشت به مبدا
    case Completed = 'completed'; // پایان سفر

    public function persian(): string
    {
        return match ($this) {
            self::BeforeOrigin => 'در مسیر مبدا',
            self::AtOrigin => 'در مبدا',
            self::ToDestination => 'در مسیر مقصد',
            self::AtDestination => 'در مقصد',
            self::ToNextDestination => 'بین مقصدها',
            self::ToOrigin => 'در حال بازگشت به مبدا',
            self::Completed => 'پایان یافته',
        };

    }
}



