# Iran Geojson Map for Metabase

## 📂 Data Source
The data is sourced from [mokazemi/iran-geojson](https://codeberg.org/mokazemi/iran-geojson).

## 🚀 Usage
You can use this GeoJSON file for visualization in **Metabase**.

## 🌏31 Provinces in Iran

It's saved on `31Provinces_Iran_Map.json` and contains boundaries of all **31 provinces of Iran**.

### 📌 Code & Display Name Table  
The table below specifies the **Region’s Identifier** and **Region’s Display Name** for use in **Metabase**:  

| #  | 🏷️ Code | 📍 Display Name (name_fa) | 📍 Display Name (name_en)           |
|----|------|---------------------------|-------------------------------------|
| 01 | 225444  | استان خراسان شمالی                    | North Khorasan Province             |
| 02 | 229593  | استان کرمان                    | Kerman Province                     |
| 03 | 229766  | استان ایلام                    | Ilam Province                       |
| 04 | 229893  | استان لرستان                    | Lorestan Province                   |
| 05 | 229958  | استان مرکزی                    | Markazi Province                    |
| 06 | 230033  | استان چهارمحال و بختیاری                    | Chaharmahal and Bakhtiyari Province |
| 07 | 241037  | استان کرمانشاه                    | Kermanshah Province                 |
| 08 | 241038  | استان همدان                    | Hamadan Province                    |
| 09 | 241471  | استان قزوین                    | Qazvin Province                     |
| 10 | 241472  | استان گیلان                    | Gilan Province                      |
| 11 | 241473  | استان زنجان                    | Zanjan Province                     |
| 12 | 241474  | استان سمنان                    | Semnan Province                     |
| 13 | 241475  | استان اصفهان                    | Isfahan Province                    |
| 14 | 241478  | استان کهگیلویه و بویر احمد                    | Kohgiluye and Buyer Ahmad Province  |
| 15 | 241546  | استان کردستان                    | Kurdistan Province                  |
| 16 | 241593  | استان آذربایجان غربی                    | West Azerbaijan Province            |
| 17 | 255446  | استان فارس                    | Fars Province                       |
| 18 | 269575  | استان بوشهر                    | Bushehr Province                    |
| 19 | 269635  | استان اردبیل                    | Ardabil Province                    |
| 20 | 269900  | استان مازندران                    | Mazandaran Province                 |
| 21 | 269903  | استان گلستان                    | Golestan Province                   |
| 22 | 537657  | استان خراسان رضوی                    | Razavi Khorasan Province            |
| 23 | 537658  | استان خراسان جنوبی                    | South Khorasan Province             |
| 24 | 537693  | استان سیستان و بلوچستان                    | Sistan and Baluchestan Province     |
| 25 | 537701  | استان تهران                    | Tehran Province                     |
| 26 | 2232180  | استان آذربایجان شرقی                    | East Azerbaijan Province            |
| 27 | 3300249  | استان یزد                    | ِYazd Province                      |
| 28 | 537702  | استان قم                    | Qom Province                        |
| 29 | 1015996  | استان البرز                    | Alborz Province                        |
| 30 | 3385992  | استان هرمزگان                    | Hormozgan Province                        |
| 31 | 3661581  | استان خوزستان                    | Khuzestan Province                        |

## 🚀 How to Use in Metabase
To use this map in Metabase, visit the following address:
[Metabase Custom Map](https://www.metabase.com/docs/latest/configuring-metabase/custom-maps).

## 💡 Note
For a specific use case, the three provinces **North Khorasan, Razavi Khorasan, and South Khorasan** were merged into a **single region**, and **Tehran** was divided into **East Tehran and West Tehran**.

To achieve this, a **customized map** was designed, which is available in `Specified_Purpose_Iran_Map.json`.

This is just one example of how this map can be **customized** to fit specific needs.


💡 If you have any questions or suggestions, feel free to open an issue!  
